<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('security_checks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('domain_id')->constrained()->onDelete('cascade');
            $table->enum('check_type', ['ssl', 'malware', 'spam', 'dns', 'general']);
            $table->enum('status', ['pass', 'fail', 'warning', 'error']);
            $table->integer('score')->default(0); // 0-100
            $table->json('details')->nullable(); // detailed check results
            $table->text('message')->nullable();
            $table->timestamp('checked_at');
            $table->timestamps();
            
            $table->index(['domain_id', 'check_type', 'checked_at']);
            $table->index(['checked_at', 'status']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('security_checks');
    }
};