<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('trust_seals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('domain_id')->constrained()->onDelete('cascade');
            $table->enum('seal_type', ['trust', 'security']); // trust = domain only, security = domain+ssl+email
            $table->string('seal_code', 32)->unique(); // unique code for iframe embedding
            $table->json('customization')->nullable(); // colors, logo, text customization
            $table->boolean('is_active')->default(true);
            $table->integer('display_count')->default(0);
            $table->timestamp('first_displayed_at')->nullable();
            $table->timestamp('last_displayed_at')->nullable();
            $table->timestamps();
            
            $table->index(['domain_id', 'seal_type']);
            $table->index('seal_code');
        });
    }

    public function down()
    {
        Schema::dropIfExists('trust_seals');
    }
};