<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Broadcaster
    |--------------------------------------------------------------------------
    |
    | This option controls the default broadcaster that will be used by the
    | framework when an event needs to be broadcast. You may set this to
    | any of the connections defined in the "connections" array below.
    |
    | Supported: "pusher", "ably", "redis", "log", "null"
    |
    */

    'default' => env('BROADCAST_DRIVER', 'null'),

    /*
    |--------------------------------------------------------------------------
    | Broadcast Connections
    |--------------------------------------------------------------------------
    |
    | Here you may define all of the broadcast connections that will be used
    | to broadcast events to other systems or over websockets. Samples of
    | each available type of connection are provided inside this array.
    |
    */

    'connections' => [

        'pusher' => [
            'driver' => 'pusher',
            'key' => env('PUSHER_APP_KEY'),
            'secret' => env('PUSHER_APP_SECRET'),
            'app_id' => env('PUSHER_APP_ID'),
            'options' => [
                'cluster' => env('PUSHER_APP_CLUSTER'),
                'host' => env('PUSHER_HOST') ?: 'api-'.env('PUSHER_APP_CLUSTER', 'mt1').'.pusherapp.com',
                'port' => env('PUSHER_PORT', 443),
                'scheme' => env('PUSHER_SCHEME', 'https'),
                'encrypted' => true,
                'useTLS' => env('PUSHER_SCHEME', 'https') === 'https',
            ],
            'client_options' => [
                // Guzzle client options: https://docs.guzzlephp.org/en/stable/request-options.html
            ],
        ],

        'ably' => [
            'driver' => 'ably',
            'key' => env('ABLY_KEY'),
        ],

        'redis' => [
            'driver' => 'redis',
            'connection' => 'default',
        ],

        'log' => [
            'driver' => 'log',
        ],

        'null' => [
            'driver' => 'null',
        ],

        // Custom WebSocket configuration for local development
        'websocket' => [
            'driver' => 'pusher',
            'key' => env('WEBSOCKET_APP_KEY', 'local-websocket-key'),
            'secret' => env('WEBSOCKET_APP_SECRET', 'local-websocket-secret'),
            'app_id' => env('WEBSOCKET_APP_ID', 'local-websocket-id'),
            'options' => [
                'host' => env('WEBSOCKET_HOST', '127.0.0.1'),
                'port' => env('WEBSOCKET_PORT', 6001),
                'scheme' => env('WEBSOCKET_SCHEME', 'http'),
                'encrypted' => false,
                'useTLS' => false,
            ],
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Broadcast Settings
    |--------------------------------------------------------------------------
    |
    | Additional settings for broadcasting functionality.
    |
    */

    'settings' => [
        // Enable/disable broadcasting globally
        'enabled' => env('BROADCAST_ENABLED', true),
        
        // Queue for broadcast jobs
        'queue' => env('BROADCAST_QUEUE', 'broadcasts'),
        
        // Connection for broadcast queue
        'queue_connection' => env('BROADCAST_QUEUE_CONNECTION', 'redis'),
        
        // Retry attempts for failed broadcasts
        'retry_attempts' => env('BROADCAST_RETRY_ATTEMPTS', 3),
        
        // Retry delay in seconds
        'retry_delay' => env('BROADCAST_RETRY_DELAY', 60),
        
        // Maximum number of listeners per channel
        'max_listeners_per_channel' => env('BROADCAST_MAX_LISTENERS', 100),
        
        // Channel authorization timeout
        'auth_timeout' => env('BROADCAST_AUTH_TIMEOUT', 30),
        
        // Enable broadcast event logging
        'log_events' => env('BROADCAST_LOG_EVENTS', false),
        
        // Channels that require authentication
        'private_channels' => [
            'user.*',
            'domain.*',
            'seal.*',
            'security.*',
            'analytics.*',
            'subscription.*',
            'admin.*',
            'premium.*',
            'bulk.*',
        ],
        
        // Channels that support presence
        'presence_channels' => [
            'presence.dashboard.*',
            'presence.domain.*',
            'system.health',
        ],
        
        // Rate limiting for broadcasts
        'rate_limits' => [
            'per_user_per_minute' => env('BROADCAST_RATE_LIMIT_USER', 60),
            'per_channel_per_minute' => env('BROADCAST_RATE_LIMIT_CHANNEL', 100),
            'global_per_minute' => env('BROADCAST_RATE_LIMIT_GLOBAL', 1000),
        ],
        
        // Event-specific settings
        'events' => [
            'security_alert' => [
                'queue' => 'high-priority',
                'delay' => 0,
                'retry_attempts' => 5,
            ],
            'domain_verified' => [
                'queue' => 'default',
                'delay' => 0,
                'retry_attempts' => 3,
            ],
            'seal_viewed' => [
                'queue' => 'low-priority',
                'delay' => 5,
                'retry_attempts' => 1,
            ],
        ],
    ],

];