<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // Run security checks daily at 2 AM
        $schedule->command('security:check-all')
            ->dailyAt('02:00')
            ->withoutOverlapping()
            ->onOneServer()
            ->runInBackground();
        
        // Process analytics and cleanup old data weekly
        $schedule->command('analytics:process --cleanup --report')
            ->weekly()
            ->sundays()
            ->at('03:00')
            ->withoutOverlapping();
        
        // Clean up old analytics data monthly (keep 90 days)
        $schedule->command('analytics:process --cleanup --days=90')
            ->monthly()
            ->withoutOverlapping();
        
        // Generate system reports weekly
        $schedule->command('analytics:process --report')
            ->weekly()
            ->mondays()
            ->at('08:00');
        
        // Clear expired password reset tokens
        $schedule->command('auth:clear-resets')
            ->everyFifteenMinutes();
        
        // Queue work (if using database queue)
        $schedule->command('queue:work --stop-when-empty')
            ->everyMinute()
            ->withoutOverlapping();
        
        // Prune telescope entries (if using Laravel Telescope)
        $schedule->command('telescope:prune --hours=48')
            ->daily();
        
        // Clear application cache weekly
        $schedule->command('cache:clear')
            ->weekly()
            ->sundays()
            ->at('04:00');
        
        // Backup database daily (example - would need actual backup command)
        // $schedule->command('backup:run --only-db')
        //     ->daily()
        //     ->at('01:00');
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}